#pragma once

#include <vector>

#include <windows.h>
#include <d3d9.h>



struct TextureSection;

class SpriteBatcher
{

  public:

    struct BatchVertex
    {
      float     X;
      float     Y;
      float     Z;
      float     RHW;
      DWORD     Color;
      float     TU;
      float     TV;
    };

    std::vector<BatchVertex>      m_Batch;

    size_t                        m_UsedBatchSize;

    IDirect3DTexture9*            m_pTexture;

    int                           m_TextureTrueWidth;
    int                           m_TextureTrueHeight;


    SpriteBatcher();


    void                          Render( LPDIRECT3DDEVICE9 pDevice );

    void                          AddBatch( LPDIRECT3DDEVICE9 pDevice, int X, int Y, float Z, const TextureSection& TexSec, DWORD Color1 = 0xffffffff, DWORD Color2 = 0xffffffff, DWORD Color3 = 0xffffffff, DWORD Color4 = 0xffffffff );
    void                          AddBatch( LPDIRECT3DDEVICE9 pDevice, int X1, int Y1, int X2, int Y2, int X3, int Y3, int X4, int Y4, float Z, const TextureSection& TexSec, DWORD Color1 = 0xffffffff, DWORD Color2 = 0xffffffff, DWORD Color3 = 0xffffffff, DWORD Color4 = 0xffffffff );

};
